/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

#define antialias 8.0

//official colors from http://en.wikipedia.org/wiki/Flag_of_the_United_States#Colors
#define white 1.0, 1.0, 1.0
#define red   .698, .132, .203
#define blue  .234, .233, .430

#define sky    0.086,  0.662, 0.788

vec4 star(vec2 uv){
	uv -= vec2(.5, .5);
	uv *= .65;
	uv.x *= 2.0;
	vec2 polar = vec2(atan(uv.x, uv.y), length(uv));
	polar.x /= 2.0*3.141592;
	
	polar.x += .5;
	
	float triangle = polar.y*3.1415*2.0*(fract(polar.x*10.0)-.5) * -sign(fract(polar.x*5.0)-.5);
	
	//triangle = cos(polar.x*5.0*2.0*3.1415);
	
	return polar.y > (triangle*.6+1.0)*.2 ? vec4(blue,1) : vec4(white,1);
}

vec2 warp(vec2 uv){
	uv.y += sin(-iGlobalTime*5.0 + uv.x*uv.x*10.0)*.2*uv.x - uv.x*.3;
	uv.x += uv.y*.05;
	return uv;
}

vec4 sample(vec2 coord){
	vec2 uv = coord / iResolution.xy;
	uv *= vec2(1.05, 1.2);
	uv -= vec2(0.05, 0.025);
	
	uv = warp(uv);
	
	vec4 color = vec4(white, 1);
	
	if(uv.x < .4 && uv.y > 6.0/13.0){
		color = vec4(blue, 1);
		
		//stars
		vec2 uv_star = (uv+vec2(0.0, 6.0/13.0)) / vec2(.4, 6.0/13.0);
		
		
		float indexxmax = 6.0;
		float indexxmin = 0.0;
		
		if(fract(uv_star.y*9.0*.5) < .5){
			uv_star.x += .5/6.0;
			indexxmin = 5.0;
			indexxmin = 1.0;
		}
		
		float indexy = floor(uv_star.y*9.0);
		float indexx = uv_star.x*6.0;
		
		
		uv_star.y -= floor(uv_star.y*9.0)/9.0;
		uv_star.y *= 9.0;
		
		
		uv_star.x -= floor(uv_star.x*6.0)/6.0;
		uv_star.x *= 6.0;
		
		
		if(indexx > indexxmin && indexx < indexxmax && indexy > 18.0 && indexy < 28.0){
			color = star(uv_star);
		}
	} else {
		//stripes
		if(fract(uv.y*6.5) < .5){
			color = vec4(red, 1);
		}
		
	}
	
	if(uv.x < 0.0 || uv.x > 1.0 || uv.y < 0.0 || uv.y > 1.0){
		color = vec4(sky,1);
	}
	
	
	return color;
}

void main(void){
	
	//do anti alias
	vec4 accum = vec4(0,0,0,0);
	
	float ct = 0.0;

	for(float x = -.5+.5/antialias; x <= .5-.25/antialias; x += 1.0/antialias){
		for(float y = -.5+.5/antialias; y <= .5-.25/antialias; y += 1.0/antialias){
			vec2 off = vec2(x, y);
			accum += sample(gl_FragCoord.xy + off);
			ct += 1.0;
		}
	}

	gl_FragColor = accum/ct;
}